from axelrod.action import Action

from axelrod.player import Player

C, D = Action.C, Action.D

class LevelPunisher(Player):
    """
    A player starts by cooperating however, after 10 rounds
    will defect if at any point the number of defections
    by an opponent is greater than 20%.

    Names:

    - Level Punisher: [Eckhart2015]_
    """

    name = "Level Punisher"
    classifier = {
        "memory_depth": float("inf"),  # Long Memory
        "stochastic": False,
        "long_run_time": False,
        "inspects_source": False,
        "manipulates_source": False,
        "manipulates_state": False,
    }

    def strategy(self, opponent: Player) -> Action:
        """Actual strategy definition that determines player's action."""
        if len(opponent.history) < 10:
            return C
        elif opponent.defections / len(opponent.history) > 0.2:
            return D
        else:
            return C